'==============================================================================
' Copyright  Micromega Corporation 2006-2007. All rights reserved
'
' @file   	GCdistance.bs2
' @target	ARMmite/ARMexpress
'
' see: Application Note 39 - Calculating Great Circle Distances
'
' This program demonstrates the calculation of great circle distances.
' It reads the current latitude and longitude position from a GPS receiver,
' then calculates the great circle distance to a number of stored locations.
' The program can also be run without a GPS connection by selecting one of
' the pre-defined locations as the 'from' location.
'
' @author Cam Thompson, Micromega Corporation
' @version
'	February 26, 2007
'	- updated for ARMbasic Version 7 syntax
'	August 3, 2007
'	- ported to ARMmite/ARMexpress
'   July 25, 2007
'   - original version
'
'==============================================================================

'-------------------- uM-FPU V3 definitions -----------------------------------

#include "FPUspi.bas"

'==============================================================================
'==================== main definitions ========================================
'==============================================================================

'-------------------- uM-FPU Register Definitions -----------------------------
const	lat1			= 10			' uM-FPU register 10
const	long1			= 11			' uM-FPU register 11
const	lat2			= 12			' uM-FPU register 12
const	long2			= 13			' uM-FPU register 13

const	dist_nm			= 20			' distance - nautical miles
const	dist_km			= 21			' distance - kilometers
const	dist_miles		= 22			' distance - miles

'-------------------- uM-FPU Function Definitions -----------------------------
const	getID			= 0				' uM-FPU user function 0
const	getDistance		= 1				' uM-FPU user function 1
const	getLocation		= 2				' uM-FPU user function 2
const	getLatLong		= 3				' uM-FPU user function 3
const	radiansToDM		= 4				' uM-FPU user function 4
const	readNMEA		= 5				' uM-FPU user function 5
const	parseGPRMC		= 6				' uM-FPU user function 6
const	NMEA_Degrees	= 7				' uM-FPU user function 7

'==============================================================================
'-------------------- main routine --------------------------------------------
'==============================================================================

Main:
	print
	print "Great Circle Distance"
		
	gosub Fpu_Reset						' reset the uM-FPU V3 chip
	if status <> SYNC_CHAR then			' check for synchronization
		print "uM-FPU not detected"
		end
	else
		gosub Print_Version				' display the uM-FPU version number
		print
	endif

	' check that user-defined functions are loaded
	SPIOUT FpuCS, FpuOut, FpuClk, [CLR0, FCALL, getID, SELECTA, 0]
	gosub Fpu_Wait
	SPIOUT FpuCS, FpuOut, FpuClk, [LREADBYTE]
	SPIIN FpuCS, FpuIn, FpuClk, [dataByte]
	if dataByte <> 39 then
		print "GCdistance.fpu functions not loaded."
    	end
	endif

	' if from = 99, read current location from GPS
	' if from <> 99, use a stored location (0 to 7)
	' ---------------------------------------------
	from = 0

	print
	print "From:"
	print "  ";
	if from = 99 then
		print "Reading GPS ...";
		SPIOUT FpuCS, FpuOut, FpuClk, [FCALL, readNMEA, STRSET, "Location", 0]
	else
		SPIOUT FpuCS, FpuOut, FpuClk, [LONGBYTE, from, FCALL, getLocation, COPY, lat2, lat1, COPY, long2, long1]
	endif

  ' display latitude and longitude
  ' ------------------------------
	SPIOUT FpuCS, FpuOut, FpuClk, [STRINS, " (", 0, SELECTA, lat1, FCALL, radiansToDM, STRINS, ", ", 0]
	SPIOUT FpuCS, FpuOut, FpuClk, [SELECTA, long1, FCALL, radiansToDM, STRINS, ")", 0]
	gosub Print_FpuString

  ' display distance to all other stored locations
  ' ----------------------------------------------
	print
	print "To:";

	for index = 0 TO 7
		if from <> index then

			print
			print "  ";
			SPIOUT FpuCS, FpuOut, FpuClk, [LONGBYTE, index, FCALL, getLocation]
			SPIOUT FpuCS, FpuOut, FpuClk, [STRINS, " (", 0, SELECTA, lat2, FCALL, radiansToDM, STRINS, ", ", 0]
			SPIOUT FpuCS, FpuOut, FpuClk, [SELECTA, long2, FCALL, radiansToDM, STRINS, ")", 0]
			gosub Print_FpuString

			print
			print "   ";
			SPIOUT FpuCS, FpuOut, FpuClk, [SELECTA, dist_nm, FCALL, getDistance, FSET0]
			format = 92
			gosub Print_FloatFormat
			print " nautical miles"

			print "   ";
			SPIOUT FpuCS, FpuOut, FpuClk, [SELECTA, dist_km, FSET, dist_nm, FWRITE0, $3F, $ED, $0E, $56, FMUL0]
			SPIOUT FpuCS, FpuOut, FpuClk, [SELECTA, dist_miles, FSET, dist_km, FCNV, 13]
			format = 92
			gosub Print_FloatFormat
			print " miles";

			print
			print "   ";
			SPIOUT FpuCS, FpuOut, FpuClk, [SELECTA, dist_km]
			format = 92
			gosub Print_FloatFormat
			print" kilometers";
		endif
	next

Done:
	print
	print "Done."
	end
